#
#	MBsysTran - Release 8.1
#
#	Copyright 
#	Universite catholique de Louvain (UCLouvain) 
#	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
#	2, Place du Levant
#	1348 Louvain-la-Neuve 
#	Belgium 
#
#	http://www.robotran.be 
#
#	==> Generation Date: Wed Sep 15 15:32:03 2021
#
#	==> Project name: five_point_suspension_python
#
#	==> Number of joints: 16
#
#	==> Function: F18 - Constraints Quadratic Velocity Terms (Jdqd)
#
#	==> Git hash: e4323cc50f813318b5c64b3b53763c941a34ce32
#

from math import sin, cos

def cons_jdqd(Jdqd, s):
    q = s.q
    qd = s.qd
 
# Trigonometric functions

    S2 = sin(q[2])
    C2 = cos(q[2])
    S3 = sin(q[3])
    C3 = cos(q[3])
    S10 = sin(q[10])
    C10 = cos(q[10])
    S11 = sin(q[11])
    C11 = cos(q[11])
    S12 = sin(q[12])
    C12 = cos(q[12])
    S13 = sin(q[13])
    C13 = cos(q[13])
    S14 = sin(q[14])
    C14 = cos(q[14])
    S4 = sin(q[4])
    C4 = cos(q[4])
    S5 = sin(q[5])
    C5 = cos(q[5])
    S6 = sin(q[6])
    C6 = cos(q[6])
    S7 = sin(q[7])
    C7 = cos(q[7])
    S8 = sin(q[8])
    C8 = cos(q[8])
    S9 = sin(q[9])
    C9 = cos(q[9])
 
# Augmented Joint Position Vectors

 
# Constraints and Constraints Jacobian

 
# Constraints Quadratic Terms

    ROjdqd1_52 = C2*C3
    ROjdqd1_62 = S2*C3
    OMjdqd1_22 = -qd[3]*S2
    OMjdqd1_32 = qd[3]*C2
    Ompqpjdqd1_22 = -qd[2]*qd[3]*C2
    Ompqpjdqd1_32 = -qd[2]*qd[3]*S2
    RLjdqd1_13 = -s.dpt[2,8]*S3
    RLjdqd1_23 = ROjdqd1_52*s.dpt[2,8]
    RLjdqd1_33 = ROjdqd1_62*s.dpt[2,8]
    ORjdqd1_13 = OMjdqd1_22*RLjdqd1_33-OMjdqd1_32*RLjdqd1_23
    ORjdqd1_23 = OMjdqd1_32*RLjdqd1_13-RLjdqd1_33*qd[2]
    ORjdqd1_33 = -OMjdqd1_22*RLjdqd1_13+RLjdqd1_23*qd[2]
    Apqpjdqd1_13 = OMjdqd1_22*ORjdqd1_33-OMjdqd1_32*ORjdqd1_23+Ompqpjdqd1_22*RLjdqd1_33-Ompqpjdqd1_32*RLjdqd1_23
    Apqpjdqd1_23 = OMjdqd1_32*ORjdqd1_13-ORjdqd1_33*qd[2]+Ompqpjdqd1_32*RLjdqd1_13
    Apqpjdqd1_33 = -OMjdqd1_22*ORjdqd1_13+ORjdqd1_23*qd[2]-Ompqpjdqd1_22*RLjdqd1_13
    ROjdqd2_22 = C10*S11
    ROjdqd2_32 = S10*S11
    ROjdqd2_52 = C10*C11
    ROjdqd2_62 = S10*C11
    ROjdqd2_43 = -S11*C12
    ROjdqd2_53 = ROjdqd2_52*C12-S10*S12
    ROjdqd2_63 = ROjdqd2_62*C12+C10*S12
    ROjdqd2_73 = S11*S12
    ROjdqd2_83 = -ROjdqd2_52*S12-S10*C12
    ROjdqd2_93 = -ROjdqd2_62*S12+C10*C12
    ROjdqd2_14 = -ROjdqd2_73*S13+C11*C13
    ROjdqd2_24 = ROjdqd2_22*C13-ROjdqd2_83*S13
    ROjdqd2_34 = ROjdqd2_32*C13-ROjdqd2_93*S13
    ROjdqd2_74 = ROjdqd2_73*C13+C11*S13
    ROjdqd2_84 = ROjdqd2_22*S13+ROjdqd2_83*C13
    ROjdqd2_94 = ROjdqd2_32*S13+ROjdqd2_93*C13
    ROjdqd2_15 = ROjdqd2_14*C14+ROjdqd2_43*S14
    ROjdqd2_25 = ROjdqd2_24*C14+ROjdqd2_53*S14
    ROjdqd2_35 = ROjdqd2_34*C14+ROjdqd2_63*S14
    ROjdqd2_45 = -ROjdqd2_14*S14+ROjdqd2_43*C14
    ROjdqd2_55 = -ROjdqd2_24*S14+ROjdqd2_53*C14
    ROjdqd2_65 = -ROjdqd2_34*S14+ROjdqd2_63*C14
    OMjdqd2_22 = -qd[11]*S10
    OMjdqd2_32 = qd[11]*C10
    Ompqpjdqd2_22 = -qd[10]*qd[11]*C10
    Ompqpjdqd2_32 = -qd[10]*qd[11]*S10
    RLjdqd2_13 = -s.dpt[2,12]*S11
    RLjdqd2_23 = ROjdqd2_52*s.dpt[2,12]
    RLjdqd2_33 = ROjdqd2_62*s.dpt[2,12]
    OMjdqd2_13 = qd[10]+qd[12]*C11
    OMjdqd2_23 = OMjdqd2_22+ROjdqd2_22*qd[12]
    OMjdqd2_33 = OMjdqd2_32+ROjdqd2_32*qd[12]
    ORjdqd2_13 = OMjdqd2_22*RLjdqd2_33-OMjdqd2_32*RLjdqd2_23
    ORjdqd2_23 = OMjdqd2_32*RLjdqd2_13-RLjdqd2_33*qd[10]
    ORjdqd2_33 = -OMjdqd2_22*RLjdqd2_13+RLjdqd2_23*qd[10]
    Ompqpjdqd2_13 = qd[12]*(OMjdqd2_22*ROjdqd2_32-OMjdqd2_32*ROjdqd2_22)
    Ompqpjdqd2_23 = Ompqpjdqd2_22+qd[12]*(OMjdqd2_32*C11-ROjdqd2_32*qd[10])
    Ompqpjdqd2_33 = Ompqpjdqd2_32+qd[12]*(-OMjdqd2_22*C11+ROjdqd2_22*qd[10])
    Apqpjdqd2_13 = OMjdqd2_22*ORjdqd2_33-OMjdqd2_32*ORjdqd2_23+Ompqpjdqd2_22*RLjdqd2_33-Ompqpjdqd2_32*RLjdqd2_23
    Apqpjdqd2_23 = OMjdqd2_32*ORjdqd2_13-ORjdqd2_33*qd[10]+Ompqpjdqd2_32*RLjdqd2_13
    Apqpjdqd2_33 = -OMjdqd2_22*ORjdqd2_13+ORjdqd2_23*qd[10]-Ompqpjdqd2_22*RLjdqd2_13
    OMjdqd2_14 = OMjdqd2_13+ROjdqd2_43*qd[13]
    OMjdqd2_24 = OMjdqd2_23+ROjdqd2_53*qd[13]
    OMjdqd2_34 = OMjdqd2_33+ROjdqd2_63*qd[13]
    Ompqpjdqd2_14 = Ompqpjdqd2_13+qd[13]*(OMjdqd2_23*ROjdqd2_63-OMjdqd2_33*ROjdqd2_53)
    Ompqpjdqd2_24 = Ompqpjdqd2_23+qd[13]*(-OMjdqd2_13*ROjdqd2_63+OMjdqd2_33*ROjdqd2_43)
    Ompqpjdqd2_34 = Ompqpjdqd2_33+qd[13]*(OMjdqd2_13*ROjdqd2_53-OMjdqd2_23*ROjdqd2_43)
    OMjdqd2_15 = OMjdqd2_14+ROjdqd2_74*qd[14]
    OMjdqd2_25 = OMjdqd2_24+ROjdqd2_84*qd[14]
    OMjdqd2_35 = OMjdqd2_34+ROjdqd2_94*qd[14]
    Ompqpjdqd2_15 = Ompqpjdqd2_14+qd[14]*(OMjdqd2_24*ROjdqd2_94-OMjdqd2_34*ROjdqd2_84)
    Ompqpjdqd2_25 = Ompqpjdqd2_24+qd[14]*(-OMjdqd2_14*ROjdqd2_94+OMjdqd2_34*ROjdqd2_74)
    Ompqpjdqd2_35 = Ompqpjdqd2_34+qd[14]*(OMjdqd2_14*ROjdqd2_84-OMjdqd2_24*ROjdqd2_74)
    RLjdqd2_16 = ROjdqd2_15*s.dpt[1,15]+ROjdqd2_45*s.dpt[2,15]+ROjdqd2_74*s.dpt[3,15]
    RLjdqd2_26 = ROjdqd2_25*s.dpt[1,15]+ROjdqd2_55*s.dpt[2,15]+ROjdqd2_84*s.dpt[3,15]
    RLjdqd2_36 = ROjdqd2_35*s.dpt[1,15]+ROjdqd2_65*s.dpt[2,15]+ROjdqd2_94*s.dpt[3,15]
    ORjdqd2_16 = OMjdqd2_25*RLjdqd2_36-OMjdqd2_35*RLjdqd2_26
    ORjdqd2_26 = -OMjdqd2_15*RLjdqd2_36+OMjdqd2_35*RLjdqd2_16
    ORjdqd2_36 = OMjdqd2_15*RLjdqd2_26-OMjdqd2_25*RLjdqd2_16
    Apqpjdqd2_16 = Apqpjdqd2_13+OMjdqd2_25*ORjdqd2_36-OMjdqd2_35*ORjdqd2_26+Ompqpjdqd2_25*RLjdqd2_36-Ompqpjdqd2_35*RLjdqd2_26
    Apqpjdqd2_26 = Apqpjdqd2_23-OMjdqd2_15*ORjdqd2_36+OMjdqd2_35*ORjdqd2_16-Ompqpjdqd2_15*RLjdqd2_36+Ompqpjdqd2_35*RLjdqd2_16
    Apqpjdqd2_36 = Apqpjdqd2_33+OMjdqd2_15*ORjdqd2_26-OMjdqd2_25*ORjdqd2_16+Ompqpjdqd2_15*RLjdqd2_26-Ompqpjdqd2_25*RLjdqd2_16
    jdqd1 = Apqpjdqd1_13-Apqpjdqd2_16
    jdqd2 = Apqpjdqd1_23-Apqpjdqd2_26
    jdqd3 = Apqpjdqd1_33-Apqpjdqd2_36
    ROjdqd3_52 = C4*C5
    ROjdqd3_62 = S4*C5
    OMjdqd3_22 = -qd[5]*S4
    OMjdqd3_32 = qd[5]*C4
    Ompqpjdqd3_22 = -qd[4]*qd[5]*C4
    Ompqpjdqd3_32 = -qd[4]*qd[5]*S4
    RLjdqd3_13 = -s.dpt[2,9]*S5
    RLjdqd3_23 = ROjdqd3_52*s.dpt[2,9]
    RLjdqd3_33 = ROjdqd3_62*s.dpt[2,9]
    ORjdqd3_13 = OMjdqd3_22*RLjdqd3_33-OMjdqd3_32*RLjdqd3_23
    ORjdqd3_23 = OMjdqd3_32*RLjdqd3_13-RLjdqd3_33*qd[4]
    ORjdqd3_33 = -OMjdqd3_22*RLjdqd3_13+RLjdqd3_23*qd[4]
    Apqpjdqd3_13 = OMjdqd3_22*ORjdqd3_33-OMjdqd3_32*ORjdqd3_23+Ompqpjdqd3_22*RLjdqd3_33-Ompqpjdqd3_32*RLjdqd3_23
    Apqpjdqd3_23 = OMjdqd3_32*ORjdqd3_13-ORjdqd3_33*qd[4]+Ompqpjdqd3_32*RLjdqd3_13
    Apqpjdqd3_33 = -OMjdqd3_22*ORjdqd3_13+ORjdqd3_23*qd[4]-Ompqpjdqd3_22*RLjdqd3_13
    ROjdqd4_22 = C10*S11
    ROjdqd4_32 = S10*S11
    ROjdqd4_52 = C10*C11
    ROjdqd4_62 = S10*C11
    ROjdqd4_43 = -S11*C12
    ROjdqd4_53 = ROjdqd4_52*C12-S10*S12
    ROjdqd4_63 = ROjdqd4_62*C12+C10*S12
    ROjdqd4_73 = S11*S12
    ROjdqd4_83 = -ROjdqd4_52*S12-S10*C12
    ROjdqd4_93 = -ROjdqd4_62*S12+C10*C12
    ROjdqd4_14 = -ROjdqd4_73*S13+C11*C13
    ROjdqd4_24 = ROjdqd4_22*C13-ROjdqd4_83*S13
    ROjdqd4_34 = ROjdqd4_32*C13-ROjdqd4_93*S13
    ROjdqd4_74 = ROjdqd4_73*C13+C11*S13
    ROjdqd4_84 = ROjdqd4_22*S13+ROjdqd4_83*C13
    ROjdqd4_94 = ROjdqd4_32*S13+ROjdqd4_93*C13
    ROjdqd4_15 = ROjdqd4_14*C14+ROjdqd4_43*S14
    ROjdqd4_25 = ROjdqd4_24*C14+ROjdqd4_53*S14
    ROjdqd4_35 = ROjdqd4_34*C14+ROjdqd4_63*S14
    ROjdqd4_45 = -ROjdqd4_14*S14+ROjdqd4_43*C14
    ROjdqd4_55 = -ROjdqd4_24*S14+ROjdqd4_53*C14
    ROjdqd4_65 = -ROjdqd4_34*S14+ROjdqd4_63*C14
    OMjdqd4_22 = -qd[11]*S10
    OMjdqd4_32 = qd[11]*C10
    Ompqpjdqd4_22 = -qd[10]*qd[11]*C10
    Ompqpjdqd4_32 = -qd[10]*qd[11]*S10
    RLjdqd4_13 = -s.dpt[2,12]*S11
    RLjdqd4_23 = ROjdqd4_52*s.dpt[2,12]
    RLjdqd4_33 = ROjdqd4_62*s.dpt[2,12]
    OMjdqd4_13 = qd[10]+qd[12]*C11
    OMjdqd4_23 = OMjdqd4_22+ROjdqd4_22*qd[12]
    OMjdqd4_33 = OMjdqd4_32+ROjdqd4_32*qd[12]
    ORjdqd4_13 = OMjdqd4_22*RLjdqd4_33-OMjdqd4_32*RLjdqd4_23
    ORjdqd4_23 = OMjdqd4_32*RLjdqd4_13-RLjdqd4_33*qd[10]
    ORjdqd4_33 = -OMjdqd4_22*RLjdqd4_13+RLjdqd4_23*qd[10]
    Ompqpjdqd4_13 = qd[12]*(OMjdqd4_22*ROjdqd4_32-OMjdqd4_32*ROjdqd4_22)
    Ompqpjdqd4_23 = Ompqpjdqd4_22+qd[12]*(OMjdqd4_32*C11-ROjdqd4_32*qd[10])
    Ompqpjdqd4_33 = Ompqpjdqd4_32+qd[12]*(-OMjdqd4_22*C11+ROjdqd4_22*qd[10])
    Apqpjdqd4_13 = OMjdqd4_22*ORjdqd4_33-OMjdqd4_32*ORjdqd4_23+Ompqpjdqd4_22*RLjdqd4_33-Ompqpjdqd4_32*RLjdqd4_23
    Apqpjdqd4_23 = OMjdqd4_32*ORjdqd4_13-ORjdqd4_33*qd[10]+Ompqpjdqd4_32*RLjdqd4_13
    Apqpjdqd4_33 = -OMjdqd4_22*ORjdqd4_13+ORjdqd4_23*qd[10]-Ompqpjdqd4_22*RLjdqd4_13
    OMjdqd4_14 = OMjdqd4_13+ROjdqd4_43*qd[13]
    OMjdqd4_24 = OMjdqd4_23+ROjdqd4_53*qd[13]
    OMjdqd4_34 = OMjdqd4_33+ROjdqd4_63*qd[13]
    Ompqpjdqd4_14 = Ompqpjdqd4_13+qd[13]*(OMjdqd4_23*ROjdqd4_63-OMjdqd4_33*ROjdqd4_53)
    Ompqpjdqd4_24 = Ompqpjdqd4_23+qd[13]*(-OMjdqd4_13*ROjdqd4_63+OMjdqd4_33*ROjdqd4_43)
    Ompqpjdqd4_34 = Ompqpjdqd4_33+qd[13]*(OMjdqd4_13*ROjdqd4_53-OMjdqd4_23*ROjdqd4_43)
    OMjdqd4_15 = OMjdqd4_14+ROjdqd4_74*qd[14]
    OMjdqd4_25 = OMjdqd4_24+ROjdqd4_84*qd[14]
    OMjdqd4_35 = OMjdqd4_34+ROjdqd4_94*qd[14]
    Ompqpjdqd4_15 = Ompqpjdqd4_14+qd[14]*(OMjdqd4_24*ROjdqd4_94-OMjdqd4_34*ROjdqd4_84)
    Ompqpjdqd4_25 = Ompqpjdqd4_24+qd[14]*(-OMjdqd4_14*ROjdqd4_94+OMjdqd4_34*ROjdqd4_74)
    Ompqpjdqd4_35 = Ompqpjdqd4_34+qd[14]*(OMjdqd4_14*ROjdqd4_84-OMjdqd4_24*ROjdqd4_74)
    RLjdqd4_16 = ROjdqd4_15*s.dpt[1,16]+ROjdqd4_45*s.dpt[2,16]+ROjdqd4_74*s.dpt[3,16]
    RLjdqd4_26 = ROjdqd4_25*s.dpt[1,16]+ROjdqd4_55*s.dpt[2,16]+ROjdqd4_84*s.dpt[3,16]
    RLjdqd4_36 = ROjdqd4_35*s.dpt[1,16]+ROjdqd4_65*s.dpt[2,16]+ROjdqd4_94*s.dpt[3,16]
    ORjdqd4_16 = OMjdqd4_25*RLjdqd4_36-OMjdqd4_35*RLjdqd4_26
    ORjdqd4_26 = -OMjdqd4_15*RLjdqd4_36+OMjdqd4_35*RLjdqd4_16
    ORjdqd4_36 = OMjdqd4_15*RLjdqd4_26-OMjdqd4_25*RLjdqd4_16
    Apqpjdqd4_16 = Apqpjdqd4_13+OMjdqd4_25*ORjdqd4_36-OMjdqd4_35*ORjdqd4_26+Ompqpjdqd4_25*RLjdqd4_36-Ompqpjdqd4_35*RLjdqd4_26
    Apqpjdqd4_26 = Apqpjdqd4_23-OMjdqd4_15*ORjdqd4_36+OMjdqd4_35*ORjdqd4_16-Ompqpjdqd4_15*RLjdqd4_36+Ompqpjdqd4_35*RLjdqd4_16
    Apqpjdqd4_36 = Apqpjdqd4_33+OMjdqd4_15*ORjdqd4_26-OMjdqd4_25*ORjdqd4_16+Ompqpjdqd4_15*RLjdqd4_26-Ompqpjdqd4_25*RLjdqd4_16
    jdqd4 = Apqpjdqd3_13-Apqpjdqd4_16
    jdqd5 = Apqpjdqd3_23-Apqpjdqd4_26
    jdqd6 = Apqpjdqd3_33-Apqpjdqd4_36
    ROjdqd5_52 = C6*C7
    ROjdqd5_62 = S6*C7
    OMjdqd5_22 = -qd[7]*S6
    OMjdqd5_32 = qd[7]*C6
    Ompqpjdqd5_22 = -qd[6]*qd[7]*C6
    Ompqpjdqd5_32 = -qd[6]*qd[7]*S6
    RLjdqd5_13 = -s.dpt[2,10]*S7
    RLjdqd5_23 = ROjdqd5_52*s.dpt[2,10]
    RLjdqd5_33 = ROjdqd5_62*s.dpt[2,10]
    ORjdqd5_13 = OMjdqd5_22*RLjdqd5_33-OMjdqd5_32*RLjdqd5_23
    ORjdqd5_23 = OMjdqd5_32*RLjdqd5_13-RLjdqd5_33*qd[6]
    ORjdqd5_33 = -OMjdqd5_22*RLjdqd5_13+RLjdqd5_23*qd[6]
    Apqpjdqd5_13 = OMjdqd5_22*ORjdqd5_33-OMjdqd5_32*ORjdqd5_23+Ompqpjdqd5_22*RLjdqd5_33-Ompqpjdqd5_32*RLjdqd5_23
    Apqpjdqd5_23 = OMjdqd5_32*ORjdqd5_13-ORjdqd5_33*qd[6]+Ompqpjdqd5_32*RLjdqd5_13
    Apqpjdqd5_33 = -OMjdqd5_22*ORjdqd5_13+ORjdqd5_23*qd[6]-Ompqpjdqd5_22*RLjdqd5_13
    ROjdqd6_22 = C10*S11
    ROjdqd6_32 = S10*S11
    ROjdqd6_52 = C10*C11
    ROjdqd6_62 = S10*C11
    ROjdqd6_43 = -S11*C12
    ROjdqd6_53 = ROjdqd6_52*C12-S10*S12
    ROjdqd6_63 = ROjdqd6_62*C12+C10*S12
    ROjdqd6_73 = S11*S12
    ROjdqd6_83 = -ROjdqd6_52*S12-S10*C12
    ROjdqd6_93 = -ROjdqd6_62*S12+C10*C12
    ROjdqd6_14 = -ROjdqd6_73*S13+C11*C13
    ROjdqd6_24 = ROjdqd6_22*C13-ROjdqd6_83*S13
    ROjdqd6_34 = ROjdqd6_32*C13-ROjdqd6_93*S13
    ROjdqd6_74 = ROjdqd6_73*C13+C11*S13
    ROjdqd6_84 = ROjdqd6_22*S13+ROjdqd6_83*C13
    ROjdqd6_94 = ROjdqd6_32*S13+ROjdqd6_93*C13
    ROjdqd6_15 = ROjdqd6_14*C14+ROjdqd6_43*S14
    ROjdqd6_25 = ROjdqd6_24*C14+ROjdqd6_53*S14
    ROjdqd6_35 = ROjdqd6_34*C14+ROjdqd6_63*S14
    ROjdqd6_45 = -ROjdqd6_14*S14+ROjdqd6_43*C14
    ROjdqd6_55 = -ROjdqd6_24*S14+ROjdqd6_53*C14
    ROjdqd6_65 = -ROjdqd6_34*S14+ROjdqd6_63*C14
    OMjdqd6_22 = -qd[11]*S10
    OMjdqd6_32 = qd[11]*C10
    Ompqpjdqd6_22 = -qd[10]*qd[11]*C10
    Ompqpjdqd6_32 = -qd[10]*qd[11]*S10
    RLjdqd6_13 = -s.dpt[2,12]*S11
    RLjdqd6_23 = ROjdqd6_52*s.dpt[2,12]
    RLjdqd6_33 = ROjdqd6_62*s.dpt[2,12]
    OMjdqd6_13 = qd[10]+qd[12]*C11
    OMjdqd6_23 = OMjdqd6_22+ROjdqd6_22*qd[12]
    OMjdqd6_33 = OMjdqd6_32+ROjdqd6_32*qd[12]
    ORjdqd6_13 = OMjdqd6_22*RLjdqd6_33-OMjdqd6_32*RLjdqd6_23
    ORjdqd6_23 = OMjdqd6_32*RLjdqd6_13-RLjdqd6_33*qd[10]
    ORjdqd6_33 = -OMjdqd6_22*RLjdqd6_13+RLjdqd6_23*qd[10]
    Ompqpjdqd6_13 = qd[12]*(OMjdqd6_22*ROjdqd6_32-OMjdqd6_32*ROjdqd6_22)
    Ompqpjdqd6_23 = Ompqpjdqd6_22+qd[12]*(OMjdqd6_32*C11-ROjdqd6_32*qd[10])
    Ompqpjdqd6_33 = Ompqpjdqd6_32+qd[12]*(-OMjdqd6_22*C11+ROjdqd6_22*qd[10])
    Apqpjdqd6_13 = OMjdqd6_22*ORjdqd6_33-OMjdqd6_32*ORjdqd6_23+Ompqpjdqd6_22*RLjdqd6_33-Ompqpjdqd6_32*RLjdqd6_23
    Apqpjdqd6_23 = OMjdqd6_32*ORjdqd6_13-ORjdqd6_33*qd[10]+Ompqpjdqd6_32*RLjdqd6_13
    Apqpjdqd6_33 = -OMjdqd6_22*ORjdqd6_13+ORjdqd6_23*qd[10]-Ompqpjdqd6_22*RLjdqd6_13
    OMjdqd6_14 = OMjdqd6_13+ROjdqd6_43*qd[13]
    OMjdqd6_24 = OMjdqd6_23+ROjdqd6_53*qd[13]
    OMjdqd6_34 = OMjdqd6_33+ROjdqd6_63*qd[13]
    Ompqpjdqd6_14 = Ompqpjdqd6_13+qd[13]*(OMjdqd6_23*ROjdqd6_63-OMjdqd6_33*ROjdqd6_53)
    Ompqpjdqd6_24 = Ompqpjdqd6_23+qd[13]*(-OMjdqd6_13*ROjdqd6_63+OMjdqd6_33*ROjdqd6_43)
    Ompqpjdqd6_34 = Ompqpjdqd6_33+qd[13]*(OMjdqd6_13*ROjdqd6_53-OMjdqd6_23*ROjdqd6_43)
    OMjdqd6_15 = OMjdqd6_14+ROjdqd6_74*qd[14]
    OMjdqd6_25 = OMjdqd6_24+ROjdqd6_84*qd[14]
    OMjdqd6_35 = OMjdqd6_34+ROjdqd6_94*qd[14]
    Ompqpjdqd6_15 = Ompqpjdqd6_14+qd[14]*(OMjdqd6_24*ROjdqd6_94-OMjdqd6_34*ROjdqd6_84)
    Ompqpjdqd6_25 = Ompqpjdqd6_24+qd[14]*(-OMjdqd6_14*ROjdqd6_94+OMjdqd6_34*ROjdqd6_74)
    Ompqpjdqd6_35 = Ompqpjdqd6_34+qd[14]*(OMjdqd6_14*ROjdqd6_84-OMjdqd6_24*ROjdqd6_74)
    RLjdqd6_16 = ROjdqd6_15*s.dpt[1,17]+ROjdqd6_45*s.dpt[2,17]+ROjdqd6_74*s.dpt[3,17]
    RLjdqd6_26 = ROjdqd6_25*s.dpt[1,17]+ROjdqd6_55*s.dpt[2,17]+ROjdqd6_84*s.dpt[3,17]
    RLjdqd6_36 = ROjdqd6_35*s.dpt[1,17]+ROjdqd6_65*s.dpt[2,17]+ROjdqd6_94*s.dpt[3,17]
    ORjdqd6_16 = OMjdqd6_25*RLjdqd6_36-OMjdqd6_35*RLjdqd6_26
    ORjdqd6_26 = -OMjdqd6_15*RLjdqd6_36+OMjdqd6_35*RLjdqd6_16
    ORjdqd6_36 = OMjdqd6_15*RLjdqd6_26-OMjdqd6_25*RLjdqd6_16
    Apqpjdqd6_16 = Apqpjdqd6_13+OMjdqd6_25*ORjdqd6_36-OMjdqd6_35*ORjdqd6_26+Ompqpjdqd6_25*RLjdqd6_36-Ompqpjdqd6_35*RLjdqd6_26
    Apqpjdqd6_26 = Apqpjdqd6_23-OMjdqd6_15*ORjdqd6_36+OMjdqd6_35*ORjdqd6_16-Ompqpjdqd6_15*RLjdqd6_36+Ompqpjdqd6_35*RLjdqd6_16
    Apqpjdqd6_36 = Apqpjdqd6_33+OMjdqd6_15*ORjdqd6_26-OMjdqd6_25*ORjdqd6_16+Ompqpjdqd6_15*RLjdqd6_26-Ompqpjdqd6_25*RLjdqd6_16
    jdqd7 = Apqpjdqd5_13-Apqpjdqd6_16
    jdqd8 = Apqpjdqd5_23-Apqpjdqd6_26
    jdqd9 = Apqpjdqd5_33-Apqpjdqd6_36
    ROjdqd7_52 = C8*C9
    ROjdqd7_62 = S8*C9
    OMjdqd7_22 = -qd[9]*S8
    OMjdqd7_32 = qd[9]*C8
    Ompqpjdqd7_22 = -qd[8]*qd[9]*C8
    Ompqpjdqd7_32 = -qd[8]*qd[9]*S8
    RLjdqd7_13 = -s.dpt[2,11]*S9
    RLjdqd7_23 = ROjdqd7_52*s.dpt[2,11]
    RLjdqd7_33 = ROjdqd7_62*s.dpt[2,11]
    ORjdqd7_13 = OMjdqd7_22*RLjdqd7_33-OMjdqd7_32*RLjdqd7_23
    ORjdqd7_23 = OMjdqd7_32*RLjdqd7_13-RLjdqd7_33*qd[8]
    ORjdqd7_33 = -OMjdqd7_22*RLjdqd7_13+RLjdqd7_23*qd[8]
    Apqpjdqd7_13 = OMjdqd7_22*ORjdqd7_33-OMjdqd7_32*ORjdqd7_23+Ompqpjdqd7_22*RLjdqd7_33-Ompqpjdqd7_32*RLjdqd7_23
    Apqpjdqd7_23 = OMjdqd7_32*ORjdqd7_13-ORjdqd7_33*qd[8]+Ompqpjdqd7_32*RLjdqd7_13
    Apqpjdqd7_33 = -OMjdqd7_22*ORjdqd7_13+ORjdqd7_23*qd[8]-Ompqpjdqd7_22*RLjdqd7_13
    ROjdqd8_22 = C10*S11
    ROjdqd8_32 = S10*S11
    ROjdqd8_52 = C10*C11
    ROjdqd8_62 = S10*C11
    ROjdqd8_43 = -S11*C12
    ROjdqd8_53 = ROjdqd8_52*C12-S10*S12
    ROjdqd8_63 = ROjdqd8_62*C12+C10*S12
    ROjdqd8_73 = S11*S12
    ROjdqd8_83 = -ROjdqd8_52*S12-S10*C12
    ROjdqd8_93 = -ROjdqd8_62*S12+C10*C12
    ROjdqd8_14 = -ROjdqd8_73*S13+C11*C13
    ROjdqd8_24 = ROjdqd8_22*C13-ROjdqd8_83*S13
    ROjdqd8_34 = ROjdqd8_32*C13-ROjdqd8_93*S13
    ROjdqd8_74 = ROjdqd8_73*C13+C11*S13
    ROjdqd8_84 = ROjdqd8_22*S13+ROjdqd8_83*C13
    ROjdqd8_94 = ROjdqd8_32*S13+ROjdqd8_93*C13
    ROjdqd8_15 = ROjdqd8_14*C14+ROjdqd8_43*S14
    ROjdqd8_25 = ROjdqd8_24*C14+ROjdqd8_53*S14
    ROjdqd8_35 = ROjdqd8_34*C14+ROjdqd8_63*S14
    ROjdqd8_45 = -ROjdqd8_14*S14+ROjdqd8_43*C14
    ROjdqd8_55 = -ROjdqd8_24*S14+ROjdqd8_53*C14
    ROjdqd8_65 = -ROjdqd8_34*S14+ROjdqd8_63*C14
    OMjdqd8_22 = -qd[11]*S10
    OMjdqd8_32 = qd[11]*C10
    Ompqpjdqd8_22 = -qd[10]*qd[11]*C10
    Ompqpjdqd8_32 = -qd[10]*qd[11]*S10
    RLjdqd8_13 = -s.dpt[2,12]*S11
    RLjdqd8_23 = ROjdqd8_52*s.dpt[2,12]
    RLjdqd8_33 = ROjdqd8_62*s.dpt[2,12]
    OMjdqd8_13 = qd[10]+qd[12]*C11
    OMjdqd8_23 = OMjdqd8_22+ROjdqd8_22*qd[12]
    OMjdqd8_33 = OMjdqd8_32+ROjdqd8_32*qd[12]
    ORjdqd8_13 = OMjdqd8_22*RLjdqd8_33-OMjdqd8_32*RLjdqd8_23
    ORjdqd8_23 = OMjdqd8_32*RLjdqd8_13-RLjdqd8_33*qd[10]
    ORjdqd8_33 = -OMjdqd8_22*RLjdqd8_13+RLjdqd8_23*qd[10]
    Ompqpjdqd8_13 = qd[12]*(OMjdqd8_22*ROjdqd8_32-OMjdqd8_32*ROjdqd8_22)
    Ompqpjdqd8_23 = Ompqpjdqd8_22+qd[12]*(OMjdqd8_32*C11-ROjdqd8_32*qd[10])
    Ompqpjdqd8_33 = Ompqpjdqd8_32+qd[12]*(-OMjdqd8_22*C11+ROjdqd8_22*qd[10])
    Apqpjdqd8_13 = OMjdqd8_22*ORjdqd8_33-OMjdqd8_32*ORjdqd8_23+Ompqpjdqd8_22*RLjdqd8_33-Ompqpjdqd8_32*RLjdqd8_23
    Apqpjdqd8_23 = OMjdqd8_32*ORjdqd8_13-ORjdqd8_33*qd[10]+Ompqpjdqd8_32*RLjdqd8_13
    Apqpjdqd8_33 = -OMjdqd8_22*ORjdqd8_13+ORjdqd8_23*qd[10]-Ompqpjdqd8_22*RLjdqd8_13
    OMjdqd8_14 = OMjdqd8_13+ROjdqd8_43*qd[13]
    OMjdqd8_24 = OMjdqd8_23+ROjdqd8_53*qd[13]
    OMjdqd8_34 = OMjdqd8_33+ROjdqd8_63*qd[13]
    Ompqpjdqd8_14 = Ompqpjdqd8_13+qd[13]*(OMjdqd8_23*ROjdqd8_63-OMjdqd8_33*ROjdqd8_53)
    Ompqpjdqd8_24 = Ompqpjdqd8_23+qd[13]*(-OMjdqd8_13*ROjdqd8_63+OMjdqd8_33*ROjdqd8_43)
    Ompqpjdqd8_34 = Ompqpjdqd8_33+qd[13]*(OMjdqd8_13*ROjdqd8_53-OMjdqd8_23*ROjdqd8_43)
    OMjdqd8_15 = OMjdqd8_14+ROjdqd8_74*qd[14]
    OMjdqd8_25 = OMjdqd8_24+ROjdqd8_84*qd[14]
    OMjdqd8_35 = OMjdqd8_34+ROjdqd8_94*qd[14]
    Ompqpjdqd8_15 = Ompqpjdqd8_14+qd[14]*(OMjdqd8_24*ROjdqd8_94-OMjdqd8_34*ROjdqd8_84)
    Ompqpjdqd8_25 = Ompqpjdqd8_24+qd[14]*(-OMjdqd8_14*ROjdqd8_94+OMjdqd8_34*ROjdqd8_74)
    Ompqpjdqd8_35 = Ompqpjdqd8_34+qd[14]*(OMjdqd8_14*ROjdqd8_84-OMjdqd8_24*ROjdqd8_74)
    RLjdqd8_16 = ROjdqd8_15*s.dpt[1,18]+ROjdqd8_45*s.dpt[2,18]+ROjdqd8_74*s.dpt[3,18]
    RLjdqd8_26 = ROjdqd8_25*s.dpt[1,18]+ROjdqd8_55*s.dpt[2,18]+ROjdqd8_84*s.dpt[3,18]
    RLjdqd8_36 = ROjdqd8_35*s.dpt[1,18]+ROjdqd8_65*s.dpt[2,18]+ROjdqd8_94*s.dpt[3,18]
    ORjdqd8_16 = OMjdqd8_25*RLjdqd8_36-OMjdqd8_35*RLjdqd8_26
    ORjdqd8_26 = -OMjdqd8_15*RLjdqd8_36+OMjdqd8_35*RLjdqd8_16
    ORjdqd8_36 = OMjdqd8_15*RLjdqd8_26-OMjdqd8_25*RLjdqd8_16
    Apqpjdqd8_16 = Apqpjdqd8_13+OMjdqd8_25*ORjdqd8_36-OMjdqd8_35*ORjdqd8_26+Ompqpjdqd8_25*RLjdqd8_36-Ompqpjdqd8_35*RLjdqd8_26
    Apqpjdqd8_26 = Apqpjdqd8_23-OMjdqd8_15*ORjdqd8_36+OMjdqd8_35*ORjdqd8_16-Ompqpjdqd8_15*RLjdqd8_36+Ompqpjdqd8_35*RLjdqd8_16
    Apqpjdqd8_36 = Apqpjdqd8_33+OMjdqd8_15*ORjdqd8_26-OMjdqd8_25*ORjdqd8_16+Ompqpjdqd8_15*RLjdqd8_26-Ompqpjdqd8_25*RLjdqd8_16
    jdqd10 = Apqpjdqd7_13-Apqpjdqd8_16
    jdqd11 = Apqpjdqd7_23-Apqpjdqd8_26
    jdqd12 = Apqpjdqd7_33-Apqpjdqd8_36
    Jdqd[1] = jdqd1
    Jdqd[2] = jdqd2
    Jdqd[3] = jdqd3
    Jdqd[4] = jdqd4
    Jdqd[5] = jdqd5
    Jdqd[6] = jdqd6
    Jdqd[7] = jdqd7
    Jdqd[8] = jdqd8
    Jdqd[9] = jdqd9
    Jdqd[10] = jdqd10
    Jdqd[11] = jdqd11
    Jdqd[12] = jdqd12

# Number of continuation lines = 0


